n = 30; p = 10; %dimension of the problem p<n
tries = 100; %number of random matrices

load('good_exp.mat','A0','A1','A2','B0','B1','B2'); n=size(A0,1); %load example

%if no example is loaded, create matrices here
%A0 = rand(n,n); A1 = rand(n,n); A2 = rand(n,n);
%B0 = rand(n,n); B1 = rand(n,n); B2 = rand(n,n);

% range in which parameter lies and discretisation accuracy
left_bound = -0.5; disk_level = 0.05; right_bound = 0.5; %seting disk_level = 0.02, takes alot of time

%functions for the parameter dependency
g1 = @(x,y) exp(x+y);
g2 = @(x,y) -exp(x+y);
h1 = @(x,y) (x+10)/(y+10);
h2 = @(x,y) (y+10)/(x+10);

%structure of the pos. def. test matrices
A = @(x,y)((A0 + g1(x,y)*A1 + g2(x,y)*A2)'*(A0 + g1(x,y)*A1 + g2(x,y)*A2));
B = @(x,y)((B0 + h1(x,y)*B1 + h2(x,y)*B2)'*(B0 + h1(x,y)*B1 + h2(x,y)*B2));


%deifinition of G(V) and H(V) for EvalG() and EvalH() see below
G = @(V) EvalG(V,A,left_bound,right_bound,disk_level);
H = @(V) EvalH(V,B,left_bound,right_bound,disk_level);


%plot parameter dependence for tries many random matrices
res1_x = [];
res1_y = [];
res2_x = [];
res2_y = [];

for i = 1:100
V = orth(rand(n,n));
V = V(:,1:p);
[x1,y1] = mu_star(V,A,left_bound,right_bound,disk_level);
[x2,y2] = xi_star(V,B,left_bound,right_bound,disk_level);
res1_x = [res1_x,x1];
res1_y = [res1_y,y1];
res2_x = [res2_x,x2];
res2_y = [res2_y,y2];
end
f1 = figure;
subplot(1,2,1); plot(1:100,res1_x,1:100,res1_y,'LineWidth',1.5)
subplot(1,2,2); plot(1:100,res2_x,1:100,res2_y,'LineWidth',1.5)
drawnow()

%compare methods

V0 = orth(rand(n));
V0 = V0(:,1:p);

tic
[V1,~,val1] = scfiter(G,H,p,1e-12,500,V0,true,'smallest');
t = toc;
fprintf(" %d/%d : %f sec\n", 1, 2, t);

tic
[V2,val2] = newscf(G,H,p,1e-12,25,20,V0,true);
t = toc;
fprintf(" %d/%d : %f sec\n", 2, 2, t);


x = 1:tries;

%calculate target function value of solutions
y1 = trace(V1'*G(V1)*V1)/trace(V1'*H(V1)*V1) * ones(1,tries);
y2 = trace(V2'*G(V2)*V2)/trace(V2'*H(V2)*V2) * ones(1,tries);
yr = zeros(1,tries);

for i =1:tries
    W = orth(rand(n,p));
    GW = G(W);
    HW = H(W);
    yr(i) = trace(W'*GW*W)/trace(W'*HW*W); %determine trace quotients for tries many random matrices
end

f2 = figure;
subplot(1,3,1);%[1,4]);
plot(x,y1,'b',x,y2,'r', x,yr,'k','LineWidth',1.5)
lgd = legend('SCF','Newton-SCF','random');

%plot of the target function of the individual procedures
subplot(1,3,2);
plot(val1,'LineWidth',1.5)
title('SCF')

subplot(1,3,3);
plot(val2,'LineWidth',1.5)
title('Newton-SCF')


function [mu_1,mu_2] = mu_star(V,A,left_bound,right_bound,disk_level)
%Calculate argmax tr(V'*A(mu)*V)
    mu_1 = left_bound;
    mu_2 = left_bound;
    opt_val = -inf;
    for x =left_bound:disk_level:right_bound
        for y =left_bound:disk_level:right_bound
            if trace(V'*A(x,y)*V) > opt_val
            mu_1 = x;
            mu_2 = y;
            opt_val = trace(V'*A(x,y)*V);
            end
        end
    end
end

function [xi_1,xi_2] = xi_star(V,B,left_bound,right_bound,disk_level)
%Calculate argmin tr(V'*B(xi)*V)
    xi_1 = left_bound;
    xi_2 = left_bound;
    opt_val = inf;
    for x =left_bound:disk_level:right_bound
        for y =left_bound:disk_level:right_bound
            if trace(V'*B(x,y)*V) < opt_val
            xi_1 = x;
            xi_2 = y;
            opt_val = trace(V'*B(x,y)*V);
            end
        end
    end
end

function G = EvalG(V,A,left_bound,right_bound,disk_level)
%auxiliary function so that above G depends only on V
    [mu_1,mu_2] = mu_star(V,A,left_bound,right_bound,disk_level);
    G = A(mu_1,mu_2);
end

function H = EvalH(V,B,left_bound,right_bound,disk_level)
%auxiliary function so that above H depends only on V
    [xi_1,xi_2] = xi_star(V,B,left_bound,right_bound,disk_level);
    H = B(xi_1,xi_2);
end
