# Linear Elliptic-Parabolic PDE system solver

This project implements four first order time integration methods for the linear coupled elliptic-parabolic PDE system solvers using the *FEniCS* computing platform.

1. implicit Euler method
2. semi-explicit Euler method
3. parabolic-elliptic iterative method
4. elliptic-parabolic iterative method

## Project structure

`solvers.py`    : implements the four methods

`utils.py`      : defines some common utility functions

`plot_utils.py` : plotting utility functions for convergence analysis

**Demo files:**

`linep.py`      : convergence analysis for the test case 1

`toy_poly.py`   : convergence analysis for the test case 2

**Configuration files:**

`prob_rock_fluid.yaml`        : definition of the test case 1

`prob_toy_poly.yaml`          : definition of the test case 2

`discretization_params.yaml`  : definition for interpolation functions and discretization parameters

**Results:**
Results of the simulation data published for the GAMMAS article is found in the folders `fluid/` and `toy_poly/`

## Requirements

Requires python3.8+ and the stable release of FEniCS 2019.

## How to execute

**Test case 1:**

`python linep.py prob_rock_fluid.yaml discretization_params.yaml`

**Test case 2:**

`python toy_poly.py prob_toy_poly.yaml discretization_params.yaml`

**Plotting:**

For test case 2:

`python plotting.py --summary_file summary.csv --problem_file prob_toy_poly.yaml --discretization_params discretization_params.yaml --log_log True --save_flg True`

## Contributors

Abdullah Mujahid <abdullah.mujahid@math.uni-augsburg.de>



