/* ----------------------------------------------------------------------
 Extension to the NUFEB package - A LAMMPS user package for Individual-based Modelling of Microbial Communities (https://github.com/nufeb/NUFEB/)
   
 Detailed description of the modifications can be found in:
 "Individual based modelling of biofilm colonisation"
 Marlis Reiber (Leibniz Universität Hannover)
 GAMM Archive for Students (GAMMAS), 3(1):1-14, 2022
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(pairtab,FixPairTab)

#else

#ifndef LMP_FIX_PAIR_TAB_H
#define LMP_FIX_PAIR_TAB_H

#include "fix.h"

namespace LAMMPS_NS {

class FixPairTab : public Fix {
 public:
  FixPairTab(class LAMMPS *, int, char **);
  virtual ~FixPairTab();
  int setmask();
  void init();
  virtual void post_force(int);

  int size_restart(int);
  int maxsize_restart();
  void reset_dt();
  
  void init_list(int, class NeighList *);
  
  enum{LINEAR};

 protected:
  char *var;
  double dt;

  class AtomVecBio *avec;
  
  int tabstyle,tablength;
  struct Table {
    int ninput; 
    double rlo,rhi;
    double *rfile,*efile,*ffile;
  };
  int ntables;
  Table *tables;
  
  void null_table(Table *);
  void read_table(Table *, char *, char *);
  void param_extract(Table *, char *);
  void bcast_table(Table *);
  void free_table(Table *);
  
  class NeighList *list;
  
};

}

#endif
#endif
