/* ----------------------------------------------------------------------
 Extension to the NUFEB package - A LAMMPS user package for Individual-based Modelling of Microbial Communities (https://github.com/nufeb/NUFEB/)
  
 Detailed description of the modifications can be found in:
 "Individual based modelling of biofilm colonisation"
 Marlis Reiber (Leibniz Universität Hannover)
 GAMM Archive for Students (GAMMAS), 3(1):1-14, 2022
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(planktonic,FixPlanktonic)

#else

#ifndef LMP_FIX_PLANKTONIC_H
#define LMP_FIX_PLANKTONIC_H

#include "fix.h"

namespace LAMMPS_NS {

class FixPlanktonic : public Fix {
 public:
  FixPlanktonic(class LAMMPS *, int, char **);
  virtual ~FixPlanktonic();
  int setmask();
  void init();
  virtual void post_force(int);

  int size_restart(int);
  int maxsize_restart();
  void reset_dt();
  
  void init_list(int, class NeighList *);  

 protected:
  char *var;
  int wallstyle;
  double lo,hi;
  double dt;
  
  int seed;
  double max_dist;
  double wall_dist;

  class AtomVecBio *avec;
  class RanMars *rng;
  class NeighList *list;
  
};

}

#endif
#endif
